<?php

namespace App\Http\Controllers;

use DateInterval;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class CommonController extends Controller
{
	// Get video details new code
	function get_video_details(Request $request, $url = "")
	{
		if ($url == "") {
			$url = $request->url;
		}

		$host = explode('.', str_replace('www.', '', strtolower(parse_url($url, PHP_URL_HOST))));
		$host = isset($host[0]) ? $host[0] : $host;

		$vimeo_api_key = get_settings('vimeo_api_key');
		$youtube_api_key = get_settings('youtube_api_key');

		if ($host == 'vimeo') {
			$video_id = substr(parse_url($url, PHP_URL_PATH), 1);
			$options = array('http' => array(
				'method'  => 'GET',
				'header' => 'Authorization: Bearer ' . $vimeo_api_key
			));
			$context  = stream_context_create($options);

			try {
				$hash = json_decode(file_get_contents("https://api.vimeo.com/videos/{$video_id}", false, $context));
			} catch (\Throwable $th) {
				$hash = '';
			}

			if ($hash == '') return;


			return array(
				'provider'          => 'Vimeo',
				'video_id'			=> $video_id,
				'title'             => $hash->name,
				'thumbnail'         => $hash->pictures->sizes[0]->link,
				'video'             => $hash->link,
				'embed_video'       => "https://player.vimeo.com/video/" . $video_id,
				'duration'			=>	gmdate("H:i:s", $hash->duration)
			);
		} elseif ($host == 'youtube' || $host == 'youtu') {
			preg_match('%(?:youtube(?:-nocookie)?\.com/(?:[^/]+/.+/|(?:v|e(?:mbed)?)/|.*[?&]v=)|youtu\.be/)([^"&?/ ]{11})%i', $url, $match);
			$video_id = $match[1];

			try {
				$hash = json_decode(file_get_contents("https://www.googleapis.com/youtube/v3/videos?part=snippet,contentDetails&id=$video_id&key=$youtube_api_key"));
			} catch (\Throwable $th) {
				$hash = '';
			}

			if ($hash == '') return;

			$duration = new DateInterval($hash->items[0]->contentDetails->duration);
			return array(
				'provider'          => 'YouTube',
				'video_id'			=> $video_id,
				'title'             => $hash->items[0]->snippet->title,
				'thumbnail'         => 'https://i.ytimg.com/vi/' . $hash->items[0]->id . '/default.jpg',
				'video'             => "http://www.youtube.com/watch?v=" . $hash->items[0]->id,
				'embed_video'       => "http://www.youtube.com/embed/" . $hash->items[0]->id,
				'duration'       	=> $duration->format('%H:%I:%S'),
			);
		} elseif ($host == 'drive') {
		}
	}

	public function rendered_view(Request $request, $path = "")
	{
		$page_data = array();
		foreach ($request->all() as $key => $value) :
			$page_data[$key] = $value;
		endforeach;

		return view($path, $page_data)->render();
	}

	// function create_organization_db()
    // {   
        
    //     $user = auth()->user();
        

    //     $prefix = 'saas';
    //     $sql_file_path = file(base_path('public/assets/install.sql'));

    //     $db_user = 'root'; // Common user (make sure this user exists)
    //     $host = 'localhost'; // Host where the DB is created

    //     // Generate a sanitized DB name
    //     $prefix = preg_replace('/[^a-z0-9_]/', '_', strtolower($prefix));
    //     $random = Str::lower(Str::random(10));
    //     $db_name = substr($prefix . '_' . $random, 0, 64);

    //     // Check if DB already exists
    //     $exists = DB::select("SELECT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = ?", [$db_name]);

    //     if (count($exists) > 0) {
    //         // Recursive retry without $this since function is not in a class
    //         return $this->create_organization_db($user);
    //     }

    //     // Create the database
    //     DB::statement("CREATE DATABASE `$db_name` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");

    //     // Grant privileges to the common user
    //     DB::statement("GRANT ALL PRIVILEGES ON `$db_name`.* TO '$db_user'@'$host'");
    //     // DB::statement("GRANT ALL PRIVILEGES ON `$db_name`.* TO '$db_user'@'$host' WITH GRANT OPTION");
    //     DB::statement("FLUSH PRIVILEGES");


    //     $this->importDb($sql_file_path, $db_name, $user);

    //     return $db_name;
    // }
	function create_organization_db($companyName, $user)
	{
		$sql_file_path = 'assets/install.sql';

		$db_user = 'root'; 
		$host = 'localhost'; 

		$prefix = preg_replace('/[^a-z0-9_]/', '_', strtolower($companyName));
		$db_name = substr($prefix, 0, 50); // safety limit

		$exists = DB::select("SELECT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = ?", [$db_name]);
		if (count($exists) > 0) {
			$db_name = $db_name . '_' . Str::lower(Str::random(5));
		}

		// Create the database
		DB::statement("CREATE DATABASE `$db_name` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");

		DB::statement("GRANT ALL PRIVILEGES ON `$db_name`.* TO '$db_user'@'$host'");
		DB::statement("FLUSH PRIVILEGES");

		$this->importDb($sql_file_path, $db_name, $user);

		return $db_name;
	}


	function importDb($sql_file_path = "", $db_name, $user)
	{
		$default_db_connection = config('database.default');
		$default_db_user = config("database.connections.$default_db_connection.username");
		$default_db_pass = config("database.connections.$default_db_connection.password");
		$default_db_host = config("database.connections.$default_db_connection.host");

		$sql_file_path = public_path($sql_file_path);

		if ($sql_file_path != '' && file_exists($sql_file_path) && is_file($sql_file_path)) {
			$dsn = "mysql:host=$default_db_host;dbname=$db_name;charset=utf8mb4";

			try {
				$pdo = new \PDO($dsn, $default_db_user, $default_db_pass, [
					\PDO::ATTR_ERRMODE => \PDO::ERRMODE_EXCEPTION,
					\PDO::MYSQL_ATTR_MULTI_STATEMENTS => true,
				]);

				$sql = file_get_contents($sql_file_path);

				$pdo->exec($sql);

				$stmt = $pdo->prepare("
					INSERT INTO users (name, email, role, status, password, created_at, updated_at) 
					VALUES (:name, :email, :role, :status, :password, :created_at, :updated_at)
				");
				$stmt->execute([
					':name'       => $user->name,
					':email'      => $user->email,
					':role'  	  => 'admin',
					':status'  	  => 1,
					':password'   => $user->password,
					':created_at' => now(),
					':updated_at' => now(),
				]);

			} catch (\Exception $e) {
				logger()->error("SQL Import Failed: " . $e->getMessage());
			}
		}
	}



}
