<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Package;
use App\Models\Company;

class Payment_history extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'payment_type',
        'package_id',
        'company_id',
        'amount',
        'invoice',
        'date_added',
        'last_modified',
        'transaction_id',
        'session_id',
        'created_at',
        'updated_at',
    ];

    public function company()
    {
        return $this->belongsTo(Company::class, 'company_id', 'id');
    }

    public function package()
    {
        return $this->belongsTo(Package::class, 'package_id', 'id');
    }
    
}
