<form action="{{ route('admin.package.store') }}" method="post" enctype="multipart/form-data">
    @csrf

    <div class="row">
        <div class="col-12">

            {{-- Package Name --}}
            <div class="mb-3">
                <label for="package_name" class="form-label ol-form-label">{{ get_phrase('Package Name') }}</label>
                <input type="text" name="title" class="form-control ol-form-control" id="package_name" 
                    placeholder="{{ get_phrase('Enter your package name') }}"
                    aria-label="{{ get_phrase('Enter your unique package name') }}" required />
            </div>

            {{-- Description --}}
            <div class="mb-3">
                <label for="description" class="form-label ol-form-label">{{ get_phrase('Package Description') }} 
                    <small class="text-muted">({{ get_phrase('optional') }})</small>
                </label>
                <textarea name="description" rows="4" class="form-control ol-form-control" id="description" 
                    placeholder="{{ get_phrase('Enter your description') }}"
                    aria-label="{{ get_phrase('Enter your description') }}"></textarea>
            </div>

            <div class="mb-3">
                <label for="features" class="form-label ol-form-label">{{ get_phrase('Features') }}</label>
                <textarea name="features" rows="3" class="form-control ol-form-control" id="features"
                    placeholder="{{ get_phrase('Enter features separated by commas') }}"></textarea>
            </div>


            {{-- Price --}}
            <div class="mb-3">
                <label for="price" class="form-label ol-form-label">{{ get_phrase('Price') }}</label>
                <input type="number" name="price" step="0.01" class="form-control ol-form-control" id="price" 
                    placeholder="{{ get_phrase('Enter price') }}"
                    aria-label="{{ get_phrase('Enter package price') }}" required />
            </div>

            {{-- Billing Cycle --}}
            <div class="mb-3">
                <label for="interval" class="form-label ol-form-label">{{ get_phrase('Interval') }}</label>
                <select name="interval" id="interval" class="form-select ol-form-control" required>
                    <option value="monthly">{{ get_phrase('Monthly') }}</option>
                    <option value="yearly">{{ get_phrase('Yearly') }}</option>
                    <option value="day">{{ get_phrase('Day') }}</option>
                </select>
            </div>

            <div class="mb-3">
                <label for="interval_preiod" class="form-label ol-form-label">{{ get_phrase('Duration ') }} 
                </label>
                <input type="number" name="interval_preiod" class="form-control ol-form-control" id="interval_preiod" 
                    placeholder="{{ get_phrase('Enter package duration') }}" 
                    aria-label="{{ get_phrase('Enter package duration') }}" />
            </div>

            {{-- Status --}}
            <div class="mb-3">
                <label for="status" class="form-label ol-form-label">{{ get_phrase('Status') }}</label>
                <select name="status" id="status" class="form-select ol-form-control" required>
                    <option value="1">{{ get_phrase('Active') }}</option>
                    <option value="0">{{ get_phrase('Inactive') }}</option>
                </select>
            </div>

            {{-- Submit Button --}}
            <div class="mb-2">
                <button class="btn ol-btn-primary">{{ get_phrase('Submit') }}</button>
            </div>

        </div>
    </div>
</form>

