<style>
 
  .subscription-header {
    background: linear-gradient(45deg, #4f46e5, #06b6d4);
  }

  .btn-danger {
    background: linear-gradient(45deg, #ef4444, #dc2626);
    border: none;
  }
  .btn-danger:hover {
    background: linear-gradient(45deg, #dc2626, #b91c1c);
  }
</style>

<div class="row mb-2">
    <div class="col-12">
        <div class="ol-card">
            <div class="ol-card-body p-3">
                <div class="subscription-card  border-0 rounded-4 overflow-hidden">
                    <!-- Header -->
                    <div class="subscription-header text-white p-4">
                    <h3 class="mb-0 fw-bold"> {{ get_phrase('Your Current Subscription') }}</h3>
                    <small>{{ get_phrase('Manage your current plan') }}</small>
                    </div>

                    <!-- Body -->
                    <div class="subscription-body p-4 bg-light bg-opacity-50">
                    <!-- Package Info -->
                    <div class="d-flex justify-content-between mb-3">
                        <span class="fw-semibold text-secondary">{{ get_phrase('Package Name') }}</span>
                        <span class="fw-bold text-dark">{{ ucfirst($activeSubscription->package->title) ?? 'N/A' }}</span>
                    </div>
                    <div class="d-flex justify-content-between mb-3">
                        <span class="fw-semibold text-secondary">Package Price</span>
                        <span class="fw-bold text-dark">{{ currency($activeSubscription->package->price) ?? 'N/A' }} / {{ ucfirst($activeSubscription->package->interval) ?? 'N/A' }}</span>
                    </div>
                    <div class="d-flex justify-content-between mb-3">
                        <span class="fw-semibold text-secondary">Expiry Date</span>
                        <span class="fw-bold text-dark">{{ \Carbon\Carbon::parse($activeSubscription->company->expire_date)->format('d M Y') }}</span>
                    </div>
                    <div class="d-flex justify-content-between align-items-center mb-1">
                        <span class="fw-semibold text-secondary">Status</span>
                        <span class="badge px-3 py-2 rounded-pill" style="background:linear-gradient(45deg,#06b6d4,#3b82f6);">
                        {{ ucfirst($activeSubscription->company->status) ?? 'N/A' }}
                        </span>
                    </div>

                    <!-- Cancel Button -->
                    <div class="text-center">
                        @if($activeSubscription->company->status == 'active')
                            <a onclick="confirmModal('{{ route('client.CancelSubscription', ['id' => $activeSubscription->company->id]) }}')" href="javascript:void(0)" class="btn btn-gradient rounded-pill px-4 py-2 fw-semibold shadow-sm" style="font-size: 14px;">{{ get_phrase('Cancel Subscription') }}</a>
                        @else
                            <a href="{{ route('client.package')}}" class="btn btn-gradient rounded-pill px-4 py-2 fw-semibold shadow-sm" style="font-size: 14px;">{{ get_phrase('Buy Package') }}</a>
                        @endif
                    </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>