<?php

use App\Http\Controllers\client\DashboardController;
use App\Http\Controllers\client\PackageController;
use App\Http\Controllers\client\MyProfileController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

Route::name('client.')->prefix('client')->middleware('client')->group(function () {

    //dashboard
    Route::get('dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::get('phpinfo', function(){
        phpinfo();
    });

    Route::get('packages', [PackageController::class, 'index'])->name('package');
    Route::get('package/purchase/{id}', [PackageController::class, 'purchasePackage'])->name('package.purchase');
    Route::post('/check-company-name', [PackageController::class, 'checkName'])->name('check.company.name');
    Route::post('package/payout/{id}', [PackageController::class, 'payout'])->name('package.payout');
    Route::any('payment/success/{identifier?}', [PackageController::class, 'payment_success'])->name('payment.success');

    Route::get('subscription-history', [PackageController::class, 'subscriptionHistory'])->name('subscription_history');
    Route::any('cancel-subscription/{id}', [PackageController::class, 'CancelSubscription'])->name('CancelSubscription');

    //manage profile
    Route::controller(MyProfileController::class)->group(function () {
        Route::get('manage_profile', 'manage_profile')->name('manage.profile');
        Route::post('manage_profile/update', 'manage_profile_update')->name('manage.profile.update');

        Route::get('manage_resume', 'manage_resume')->name('manage.resume');
        Route::post('resume/education-add', 'education_add')->name('manage.education_add');
        Route::post('resume/education-update/{index}', 'education_update')->name('manage.education_update');
        Route::get('resume/education-remove/{index}', 'education_remove')->name('manage.education.remove');
    });

});