          <div class="table-responsive">
              <table class="table table-bordered table-striped align-middle">
                  <thead class="table-dark text-center">
                      <tr>
                          <th>#</th>
                          <th><?php echo e(get_phrase('Domain URL')); ?></th>
                          <th><?php echo e(get_phrase('Status')); ?></th>
                          <th><?php echo e(get_phrase('Expired Date')); ?></th>
                          <th><?php echo e(get_phrase('Created Date')); ?></th>
                      </tr>
                  </thead>
                  <tbody>
                      <?php $__empty_1 = true; $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                          <tr>
                              <td class="text-center"><?php echo e($key + 1); ?></td>
                              <td>
                                  <a href="<?php echo e($company->company_url); ?>" target="_blank" class="text-decoration-underline text-primary">
                                      <?php echo e($company->company_url); ?>

                                  </a>
                              </td>
                              <td class="text-center">
                                  <?php if($company->status == 'active'): ?>
                                      <span class="badge bg-success"><?php echo e(ucfirst($company->status)); ?></span>
                                  <?php elseif($company->status == 'expired'): ?>
                                      <span class="badge bg-danger"><?php echo e(ucfirst($company->status)); ?></span>
                                  <?php elseif($company->status == 'canceled'): ?>
                                      <span class="badge bg-danger"><?php echo e(ucfirst($company->status)); ?></span>
                                  <?php else: ?>
                                      <span class="badge bg-secondary"><?php echo e(ucfirst($company->status)); ?></span>
                                  <?php endif; ?>
                              </td>
                              <td class="text-center"><?php echo e(\Carbon\Carbon::parse($company->expire_date)->format('d M, Y')); ?></td>
                              <td class="text-center"><?php echo e(\Carbon\Carbon::parse($company->purchase_date)->format('d M, Y')); ?></td>
                          </tr>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                          <tr>
                              <td colspan="5" class="text-center text-muted">
                                  <?php echo e(get_phrase('No domain history found')); ?>

                              </td>
                          </tr>
                      <?php endif; ?>
                  </tbody>
              </table><?php /**PATH C:\MAMP\htdocs\academyLMS_sass\Academy-LMS\resources\views/admin/client/domain_history.blade.php ENDPATH**/ ?>