<?php $current_route = Route::currentRouteName(); ?>

<div class="sidebar-logo-area">
    <a href="#" class="sidebar-logos">
        <img class="sidebar-logo-lg" height="50px" src="<?php echo e(get_image(get_frontend_settings('dark_logo'))); ?>" alt="">
        <img class="sidebar-logo-sm" height="40px" src="<?php echo e(get_image(get_frontend_settings('favicon'))); ?>" alt="">
    </a>
    <button class="sidebar-cross menu-toggler d-block d-lg-none">
        <span class="fi-rr-cross"></span>
    </button>
</div>
<h3 class="sidebar-title fs-12px px-30px pb-20px text-uppercase mt-4"><?php echo e(get_phrase('Main Menu')); ?></h3>
<div class="sidebar-nav-area">
    <nav class="sidebar-nav">
        <ul class="px-14px pb-24px">

            <li class="sidebar-first-li <?php echo e($current_route == 'instructor.dashboard' ? 'active' : ''); ?>">
                <a href="<?php echo e(route('instructor.dashboard')); ?>">
                    <span class="icon fi-rr-house-blank"></span>
                    <div class="text">
                        <span><?php echo e(get_phrase('Dashboard')); ?></span>
                    </div>
                </a>
            </li>


            <li class="sidebar-first-li first-li-have-sub <?php if($current_route == 'instructor.courses' || $current_route == 'instructor.course.create' || $current_route == 'instructor.course.edit'): ?> active showMenu <?php endif; ?>">
                <a href="javascript:void(0);">
                    <span class="icon fi fi-rr-e-learning"></span>
                    <div class="text">
                        <span><?php echo e(get_phrase('Course')); ?></span>
                    </div>
                </a>
                <ul class="first-sub-menu">
                    <li class="first-sub-menu-title fs-14px mb-18px"><?php echo e(get_phrase('Course')); ?></li>
                    <li class="sidebar-second-li <?php if($current_route == 'instructor.courses' || $current_route == 'instructor.course.edit'): ?> active <?php endif; ?>">
                        <a href="<?php echo e(route('instructor.courses')); ?>"><?php echo e(get_phrase('Manage Courses')); ?></a>
                    </li>
                    <li class="sidebar-second-li <?php if($current_route == 'instructor.course.create'): ?> active <?php endif; ?>">
                        <a href="<?php echo e(route('instructor.course.create')); ?>"><?php echo e(get_phrase('Add New Course')); ?></a>
                    </li>
                </ul>
            </li>


            <li
                class="sidebar-first-li first-li-have-sub <?php echo e($current_route == 'instructor.bootcamps' || $current_route == 'instructor.bootcamp.purchase.history' || $current_route == 'instructor.bootcamp.purchase.invoice' || $current_route == 'instructor.bootcamp.create' || $current_route == 'instructor.bootcamp.edit' || $current_route == 'instructor.bootcamp.categories' ? 'active' : ''); ?>">
                <a href="javascript:void(0);">
                    <span class="icon fi fi-sr-users-alt"></span>
                    <div class="text">
                        <span><?php echo e(get_phrase('Bootcamp')); ?></span>
                    </div>
                </a>
                <ul class="first-sub-menu">
                    <li class="first-sub-menu-title fs-14px mb-18px"><?php echo e(get_phrase('Bootcamp')); ?></li>

                    <li class="sidebar-second-li <?php if(($current_route == 'instructor.bootcamps' || $current_route == 'instructor.bootcamp.edit') && request('type') == ''): ?> active <?php endif; ?>"><a href="<?php echo e(route('instructor.bootcamps')); ?>"><?php echo e(get_phrase('Manage Bootcamps')); ?></a></li>
                    <li class="sidebar-second-li <?php if($current_route == 'instructor.bootcamp.create'): ?> active <?php endif; ?>">
                        <a href="<?php echo e(route('instructor.bootcamp.create')); ?>"><?php echo e(get_phrase('Add New Bootcamp')); ?></a>
                    </li>
                    <li class="sidebar-second-li <?php echo e($current_route == 'instructor.bootcamp.purchase.history' || $current_route == 'instructor.bootcamp.purchase.invoice' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('instructor.bootcamp.purchase.history')); ?>"><?php echo e(get_phrase('Purchase History')); ?></a>
                    </li>
                </ul>
            </li>


            

            <li class="sidebar-first-li first-li-have-sub <?php if($current_route == 'instructor.my_subjects' ||  $current_route == 'instructor.manage_schedules' || $current_route == 'instructor.manage_schedules_by_date' || $current_route == 'instructor.add_schedule' || $current_route == 'instructor.tutor_booking_list'): ?> active showMenu <?php endif; ?>">
                <a href="javascript:void(0);">
                    <span class="icon fi fi-rr-document-signed"></span>
                    <div class="text">
                        <span><?php echo e(get_phrase('Tutor Booking')); ?></span>
                    </div>
                </a>
                <ul class="first-sub-menu">
                    <li class="first-sub-menu-title fs-14px mb-18px"><?php echo e(get_phrase('Tutor Booking')); ?></li>
                    <li class="sidebar-second-li <?php if($current_route == 'instructor.my_subjects'): ?> active <?php endif; ?>">
                        <a href="<?php echo e(route('instructor.my_subjects')); ?>"><?php echo e(get_phrase('My Subjects')); ?></a>
                    </li>
                    <li class="sidebar-second-li <?php if($current_route == 'instructor.manage_schedules' || $current_route == 'instructor.manage_schedules_by_date'): ?> active <?php endif; ?>">
                        <a href="<?php echo e(route('instructor.manage_schedules')); ?>"><?php echo e(get_phrase('Manage Schedules')); ?></a>
                    </li>
                    <li class="sidebar-second-li <?php if($current_route == 'instructor.add_schedule'): ?> active <?php endif; ?>">
                        <a href="<?php echo e(route('instructor.add_schedule')); ?>"><?php echo e(get_phrase('Add Booking')); ?></a>
                    </li>
                    <li class="sidebar-second-li <?php echo e($current_route == 'instructor.tutor_booking_list' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('instructor.tutor_booking_list', ['tab' => 'live_and_upcoming'])); ?>"><?php echo e(get_phrase('All Bookings')); ?></a>
                    </li>
                </ul>
            </li>

            

            <li class="sidebar-first-li first-li-have-sub <?php if(
                $current_route == 'instructor.ebooks' ||
                    $current_route == 'instructor.ebook.edit' ||
                    $current_route == 'instructor.ebook.create' ||
                    $current_route == 'instructor.ebook.instructor-revenue'): ?> active showMenu <?php endif; ?>">
                <a href="javascript:void(0);">
                    <span class="icon fi fi-rr-book-bookmark"></span>
                    <div class="text">
                        <span><?php echo e(get_phrase('Ebook')); ?></span>
                    </div>
                </a>
                <ul class="first-sub-menu">
                    <li class="first-sub-menu-title fs-14px mb-18px"><?php echo e(get_phrase('Ebook')); ?></li>
                    <li class="sidebar-second-li <?php if($current_route == 'instructor.ebooks' || $current_route == 'instructor.ebook.edit'): ?> active <?php endif; ?>">
                        <a href="<?php echo e(route('instructor.ebooks')); ?>"><?php echo e(get_phrase('Manage Ebooks')); ?></a>
                    </li>
                    <li class="sidebar-second-li <?php if($current_route == 'instructor.ebook.create'): ?> active <?php endif; ?>">
                        <a href="<?php echo e(route('instructor.ebook.create')); ?>"><?php echo e(get_phrase('Add New Ebook')); ?></a>
                    </li>

                    <li class="sidebar-second-li <?php if($current_route == 'instructor.ebook.instructor-revenue'): ?> active <?php endif; ?>">
                        <a
                            href="<?php echo e(route('instructor.ebook.instructor-revenue')); ?>"><?php echo e(get_phrase('Instructor revenue')); ?></a>
                    </li>

                </ul>
            </li>

            


            <li class="sidebar-first-li <?php echo e($current_route == 'instructor.sales.report' ? 'active' : ''); ?>">
                <a href="<?php echo e(route('instructor.sales.report')); ?>">
                    <span class="icon fi fi-sr-arrow-trend-up"></span>
                    <div class="text">
                        <span><?php echo e(get_phrase('Sales')); ?></span>
                    </div>
                </a>
            </li>

            <li class="sidebar-first-li first-li-have-sub <?php if($current_route == 'instructor.payout.reports' || $current_route == 'instructor.payout.setting'): ?> active showMenu <?php endif; ?>">
                <a href="javascript:void(0);">
                    <span class="icon fi fi-rr-file-invoice-dollar"></span>
                    <div class="text">
                        <span><?php echo e(get_phrase('Payout')); ?></span>
                    </div>
                </a>
                <ul class="first-sub-menu">
                    <li class="first-sub-menu-title fs-14px mb-18px"><?php echo e(get_phrase('Payout')); ?></li>
                    <li class="sidebar-second-li <?php if($current_route == 'instructor.payout.reports' || $current_route == 'instructor.course.edit'): ?> active <?php endif; ?>">
                        <a href="<?php echo e(route('instructor.payout.reports')); ?>"><?php echo e(get_phrase('Withdraw')); ?></a>
                    </li>
                    <li class="sidebar-second-li <?php if($current_route == 'instructor.payout.setting'): ?> active <?php endif; ?>">
                        <a href="<?php echo e(route('instructor.payout.setting')); ?>"><?php echo e(get_phrase('Settings')); ?></a>
                    </li>
                </ul>
            </li>


            <?php if(get_frontend_settings('instructors_blog_permission')): ?>
                <li class="sidebar-first-li first-li-have-sub <?php if($current_route == 'instructor.blogs' || $current_route == 'instructor.blog.create' || $current_route == 'instructor.blog.edit' || $current_route == 'instructor.blog.pending'): ?> active showMenu <?php endif; ?>">
                    <a href="javascript:void(0);">
                        <span class="icon fi fi-rr-blog-text"></span>
                        <div class="text">
                            <span><?php echo e(get_phrase('Blogs')); ?></span>
                        </div>
                    </a>
                    <ul class="first-sub-menu">
                        <li class="first-sub-menu-title fs-14px mb-18px"><?php echo e(get_phrase('Blogs')); ?></li>
                        <li class="sidebar-second-li <?php if($current_route == 'instructor.blogs' || $current_route == 'instructor.blog.edit'): ?> active <?php endif; ?>">
                            <a href="<?php echo e(route('instructor.blogs')); ?>"><?php echo e(get_phrase('Manage Blogs')); ?></a>
                        </li>
                        <li class="sidebar-second-li <?php if($current_route == 'instructor.blog.create'): ?> active <?php endif; ?>">
                            <a href="<?php echo e(route('instructor.blog.create')); ?>"><?php echo e(get_phrase('Add New Blog')); ?></a>
                        </li>
                        <li class="sidebar-second-li <?php if($current_route == 'instructor.blog.pending'): ?> active <?php endif; ?>">
                            <a href="<?php echo e(route('instructor.blog.pending')); ?>"><?php echo e(get_phrase('Pending Blogs')); ?></a>
                        </li>
                    </ul>
                </li>
            <?php endif; ?>

            <li class="sidebar-first-li first-li-have-sub <?php if($current_route == 'instructor.manage.profile' || $current_route == 'instructor.manage.resume'): ?> active showMenu <?php endif; ?>">
                <a href="javascript:void(0);">
                    <span class="icon fi-rr-circle-user"></span>
                    <div class="text">
                        <span><?php echo e(get_phrase('Manage Profile')); ?></span>
                    </div>
                </a>
                <ul class="first-sub-menu">
                    <li class="first-sub-menu-title fs-14px mb-18px"><?php echo e(get_phrase('Manage Profile')); ?></li>
                    <li class="sidebar-second-li <?php if($current_route == 'instructor.manage.profile'): ?> active <?php endif; ?>">
                        <a href="<?php echo e(route('instructor.manage.profile')); ?>"><?php echo e(get_phrase('Profile Settings')); ?></a>
                    </li>
                    <li class="sidebar-second-li <?php if($current_route == 'instructor.manage.resume'): ?> active <?php endif; ?>">
                        <a href="<?php echo e(route('instructor.manage.resume')); ?>"><?php echo e(get_phrase('Manage Resume')); ?></a>
                    </li>
                </ul>
            </li>
        </ul>
    </nav>
</div>
<?php /**PATH C:\MAMP\htdocs\academyLMS_sass\Academy-LMS\resources\views/instructor/navigation.blade.php ENDPATH**/ ?>