<form action="<?php echo e(route('admin.package.update', ['id' => $package->id])); ?>" method="post">
        <?php echo csrf_field(); ?>

        
        <div class="mb-3">
            <label for="package_name" class="form-label ol-form-label"><?php echo e(get_phrase('Package Name')); ?></label>
            <input type="text" name="title" class="form-control ol-form-control" id="package_name" 
                value="<?php echo e(old('title', $package->title)); ?>"
                placeholder="<?php echo e(get_phrase('Enter your package name')); ?>" required />
        </div>

        
        <div class="mb-3">
            <label for="description" class="form-label ol-form-label"><?php echo e(get_phrase('Package Description')); ?> 
                <small class="text-muted">(<?php echo e(get_phrase('optional')); ?>)</small>
            </label>
            <textarea name="description" rows="4" class="form-control ol-form-control" 
                id="description" placeholder="<?php echo e(get_phrase('Enter your description')); ?>"><?php echo e(old('description', $package->description)); ?></textarea>
        </div>

        
        <div class="mb-3">
            <label for="price" class="form-label ol-form-label"><?php echo e(get_phrase('Price')); ?></label>
            <input type="number" name="price" step="0.01" class="form-control ol-form-control" id="price" 
                value="<?php echo e(old('price', $package->price)); ?>"
                placeholder="<?php echo e(get_phrase('Enter price')); ?>" required />
        </div>

        <div class="mb-3">
                <label for="interval" class="form-label ol-form-label"><?php echo e(get_phrase('Interval')); ?></label>
                <select name="interval" id="interval" class="form-select ol-form-control" required>
                    <option value="monthly" <?php echo e(old('interval', $package->interval) =='monthly' ? 'selected' : ''); ?>>
                        <?php echo e(get_phrase('Monthly')); ?>

                    </option>
                    <option value="yearly" <?php echo e(old('interval', $package->interval) == 'yearly' ? 'selected' : ''); ?>> 
                        <?php echo e(get_phrase('Yearly')); ?>

                    </option>
                    <option value="day" <?php echo e(old('interval', $package->interval) == 'day' ? 'selected' : ''); ?>>
                        <?php echo e(get_phrase('day')); ?>

                    </option>
                </select>
            </div>

            
            <div class="mb-3">
                <label for="interval_preiod" class="form-label ol-form-label"><?php echo e(get_phrase('Duration ')); ?> 
                </label>
                <input type="number" name="interval_preiod" class="form-control ol-form-control" id="interval_preiod" value="<?php echo e(old('interval_preiod', $package->interval_preiod)); ?>"
                    placeholder="<?php echo e(get_phrase('Enter package duration')); ?>" 
                    aria-label="<?php echo e(get_phrase('Enter package duration')); ?>" />
            </div>

        
        <?php
            $features = $package->features ? implode(', ', json_decode($package->features, true)) : '';
        ?>
        <div class="mb-3">
            <label for="features" class="form-label ol-form-label"><?php echo e(get_phrase('Features')); ?></label>
            <textarea name="features" rows="3" class="form-control ol-form-control" id="features"
                placeholder="<?php echo e(get_phrase('Enter features separated by commas')); ?>"><?php echo e(old('features', $features)); ?></textarea>
        </div>

        
        <div class="mb-3">
            <label for="status" class="form-label ol-form-label"><?php echo e(get_phrase('Status')); ?></label>
            <select name="status" id="status" class="form-select ol-form-control" required>
                <option value="1" <?php echo e(old('status', $package->status) == 1 ? 'selected' : ''); ?>>
                    <?php echo e(get_phrase('Active')); ?>

                </option>
                <option value="0" <?php echo e(old('status', $package->status) == 0 ? 'selected' : ''); ?>>
                    <?php echo e(get_phrase('Inactive')); ?>

                </option>
            </select>
        </div>

        
        <div class="mb-2">
            <button class="btn ol-btn-primary"><?php echo e(get_phrase('Update')); ?></button>
        </div>
</form><?php /**PATH C:\MAMP\htdocs\academyLMS_sass\Academy-LMS\resources\views/admin/package/edit.blade.php ENDPATH**/ ?>