<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;

class EmailVerificationNotificationController extends Controller
{
    /**
     * Send a new email verification notification.
     */
    public function store(Request $request): RedirectResponse
    {
        if ($request->user()->hasVerifiedEmail()) {
            // return redirect()->intended('/'.$request->segment(1).RouteServiceProvider::HOME);
            $company_slug = $request->segment(1);

        if (
            empty($company_slug) || 
            in_array($company_slug, ['login', 'logout', 'register', 'client', 'superadmin'])
        ) {
            return redirect()->intended(RouteServiceProvider::HOME);
        } else {
            return redirect()->intended('/' . $company_slug . RouteServiceProvider::HOME);
        }
        }

        $request->user()->sendEmailVerificationNotification();

        return back()->with('status', 'verification-link-sent');
    }
}
