@php $current_route = Route::currentRouteName(); @endphp

<div class="sidebar-logo-area">
    <a href="#" class="sidebar-logos">
        <img class="sidebar-logo-lg" height="50px" src="{{ get_image(get_frontend_settings('dark_logo')) }}"
            alt="">
        <img class="sidebar-logo-sm" height="40px" src="{{ get_image(get_frontend_settings('favicon')) }}" alt="">
    </a>
    <button class="sidebar-cross menu-toggler d-block d-lg-none">
        <span class="fi-rr-cross"></span>
    </button>
</div>
<h3 class="sidebar-title fs-12px px-30px pb-20px text-uppercase mt-4">{{ get_phrase('Main Menu') }}</h3>
<div class="sidebar-nav-area">
    <nav class="sidebar-nav">
        <ul class="px-14px pb-24px">

            <li class="sidebar-first-li {{ $current_route == 'client.package' || $current_route == 'client.package.purchase' ? 'active' : '' }}">
                <a href="{{ route('client.package') }}">
                    <span class="icon fi-rr-chart-tree-map"></span>
                    <div class="text">
                        <span>{{ get_phrase('Packages') }}</span>
                    </div>
                </a>
            </li>

            <li class="sidebar-first-li {{ $current_route == 'client.subscription_history' ? 'active' : '' }}">
                <a href="{{ route('client.subscription_history') }}">
                    <span class="icon fi-rr-comment-dollar"></span>
                    <div class="text">
                        <span>{{ get_phrase('Subscription History') }}</span>
                    </div>
                </a>
            </li>

            <li class="sidebar-first-li first-li-have-sub @if ($current_route == 'client.manage.profile') active showMenu @endif">
                <a href="javascript:void(0);">
                    <span class="icon fi-rr-circle-user"></span>
                    <div class="text">
                        <span>{{ get_phrase('Manage Profile') }}</span>
                    </div>
                </a>
                <ul class="first-sub-menu">
                    <li class="first-sub-menu-title fs-14px mb-18px">{{ get_phrase('Manage Profile') }}</li>
                    <li class="sidebar-second-li @if ($current_route == 'client.manage.profile') active @endif">
                        <a href="{{ route('client.manage.profile') }}">{{ get_phrase('Profile Settings') }}</a>
                    </li>
                </ul>
            </li>
            
        </ul>
    </nav>

</div>

<script>
    "use strict";
    document.addEventListener("DOMContentLoaded", function() {
        // Restore scroll position if it exists in localStorage
        const scrollPos = localStorage.getItem('navScrollPos');
        const sidebarNavArea = document.querySelector('.sidebar-nav-area');
        if (scrollPos) {
            sidebarNavArea.scrollTop = scrollPos;
        }

        // Ensure the active element is visible
        const activeElement = document.querySelector('.sidebar-nav-area .active');
        if (activeElement) {
            const activeElementTop = activeElement.getBoundingClientRect().top;
            const navAreaTop = sidebarNavArea.getBoundingClientRect().top;
            const navAreaBottom = navAreaTop + sidebarNavArea.clientHeight;

            if (activeElementTop < navAreaTop || activeElementTop > navAreaBottom) {
                sidebarNavArea.scrollTop = activeElement.offsetTop - sidebarNavArea.offsetTop;
            }
        }

        // Save scroll position before page unload
        window.addEventListener('beforeunload', function() {
            localStorage.setItem('navScrollPos', sidebarNavArea.scrollTop);
        });
    });
</script>
