@php $current_route = Route::currentRouteName(); @endphp

<div class="sidebar-logo-area">
    <a href="#" class="sidebar-logos">
        <img class="sidebar-logo-lg" height="50px" src="{{ get_image(get_frontend_settings('dark_logo')) }}"
            alt="">
        <img class="sidebar-logo-sm" height="40px" src="{{ get_image(get_frontend_settings('favicon')) }}" alt="">
    </a>
    <button class="sidebar-cross menu-toggler d-block d-lg-none">
        <span class="fi-rr-cross"></span>
    </button>
</div>
<h3 class="sidebar-title fs-12px px-30px pb-20px text-uppercase mt-4">{{ get_phrase('Main Menu') }}</h3>
<div class="sidebar-nav-area">
    <nav class="sidebar-nav">
        <ul class="px-14px pb-24px">

                <li class="sidebar-first-li {{ $current_route == 'superadmin.dashboard' ? 'active' : '' }}">
                    <a href="{{ route('superadmin.dashboard') }}">
                        <span class="icon fi-rr-house-blank"></span>
                        <div class="text">
                            <span>{{ get_phrase('Dashboard') }}</span>
                        </div>
                    </a>
                </li>

                <li class="sidebar-first-li {{ $current_route == 'superadmin.client.index' ? 'active' : '' }}">
                    <a href="{{ route('superadmin.client.index') }}">
                        <span class="icon fi-rr-users"></span>
                        <div class="text">
                            <span>{{ get_phrase('Users') }}</span>
                        </div>
                    </a>
                </li>

                <li class="sidebar-first-li {{ $current_route == 'superadmin.package.index' ? 'active' : '' }}">
                    <a href="{{ route('superadmin.package.index') }}">
                        <span class="icon fi-rr-chart-tree-map"></span>
                        <div class="text">
                            <span>{{ get_phrase('Package') }}</span>
                        </div>
                    </a>
                </li>

                <li class="sidebar-first-li {{ $current_route == 'superadmin.payment_history.index' ? 'active' : '' }}">
                    <a href="{{ route('superadmin.payment_history.index') }}">
                        <span class="icon fi-rr-comment-dollar"></span>
                        <div class="text">
                            <span>{{ get_phrase('Payment History') }}</span>
                        </div>
                    </a>
                </li>

        </ul>
    </nav>



    @if (has_permission('admin.system.settings') ||
            has_permission('admin.website.settings') ||
            has_permission('admin.payment.settings') ||
            has_permission('admin.manage.language') ||
            has_permission('admin.notification.settings') ||
            // has_permission('admin.zapier.settings') ||
            has_permission('admin.amazom_s3.settings') ||
            has_permission('admin.live.class.settings') ||
            has_permission('admin.certificate.settings') ||
            has_permission('admin.player.settings') ||
            has_permission('admin.open.ai.settings') ||
            has_permission('admin.pages') ||
            has_permission('admin.seo.settings') ||
            has_permission('admin.about'))
        <nav class="sidebar-nav">
            <h3 class="sidebar-title fs-12px px-30px text-uppercase pb-3">{{ get_phrase('Settings') }}</h3>
            <ul class="px-14px pb-24px mb-5 pb-5">
                <li
                    class="sidebar-first-li first-li-have-sub {{ $current_route == 'admin.system.settings' || $current_route == 'admin.website.settings' || $current_route == 'admin.language.phrase.edit' || $current_route == 'admin.payment.settings' || $current_route == 'admin.manage.language' || $current_route == 'admin.notification.settings' || $current_route == 'admin.amazom_s3.settings' || $current_route == 'admin.live.class.settings' || $current_route == 'admin.live.class.settings' || $current_route == 'admin.certificate.settings' || $current_route == 'admin.player.settings' || $current_route == 'admin.open.ai.settings' || $current_route == 'admin.pages' || $current_route == 'admin.seo.settings' || $current_route == 'admin.about' ? 'active' : '' }}">
                    <a href="javascript:void(0);">
                        <span class="icon fi fi-rr-settings"></span>
                        <div class="text">
                            <span>{{ get_phrase('System Settings') }}</span>
                        </div>
                    </a>
                    <ul class="first-sub-menu">
                        <li class="first-sub-menu-title fs-14px mb-18px">{{ get_phrase('System Settings') }}</li>
                        @if (has_permission('admin.system.settings'))
                            <li
                                class="sidebar-second-li {{ $current_route == 'admin.system.settings' ? 'active' : '' }}">
                                <a
                                    href="{{ route('admin.system.settings') }}">{{ get_phrase('System Settings') }}</a>
                            </li>
                        @endif
                        @if (has_permission('admin.website.settings'))
                            <li
                                class="sidebar-second-li {{ $current_route == 'admin.website.settings' ? 'active' : '' }}">
                                <a
                                    href="{{ route('admin.website.settings') }}">{{ get_phrase('Website Settings') }}</a>
                            </li>
                        @endif
                        @if (has_permission('admin.payment.settings'))
                            <li
                                class="sidebar-second-li {{ $current_route == 'admin.payment.settings' ? 'active' : '' }}">
                                <a
                                    href="{{ route('admin.payment.settings') }}">{{ get_phrase('Payment Settings') }}</a>
                            </li>
                        @endif
                        @if (has_permission('admin.manage.language'))
                            <li
                                class="sidebar-second-li {{ $current_route == 'admin.manage.language' || $current_route == 'admin.language.phrase.edit' ? 'active' : '' }}">
                                <a
                                    href="{{ route('admin.manage.language') }}">{{ get_phrase('Manage Language') }}</a>
                            </li>
                        @endif
                        @if (has_permission('admin.live.class.settings'))
                            <li
                                class="sidebar-second-li {{ $current_route == 'admin.live.class.settings' ? 'active' : '' }}">
                                <a
                                    href="{{ route('admin.live.class.settings') }}">{{ get_phrase('Live Class Settings') }}</a>
                            </li>
                        @endif
                        @if (has_permission('admin.notification.settings'))
                            <li
                                class="sidebar-second-li {{ $current_route == 'admin.notification.settings' ? 'active' : '' }}">
                                <a
                                    href="{{ route('admin.notification.settings') }}">{{ get_phrase('SMTP Settings') }}</a>
                            </li>
                        @endif
                        @if (has_permission('admin.amazom_s3.settings'))
                            <li
                                class="sidebar-second-li {{ $current_route == 'admin.amazom_s3.settings' ? 'active' : '' }}">
                                <a
                                    href="{{ route('admin.amazom_s3.settings') }}">{{ get_phrase('Amazon s3 settings ') }}</a>
                            </li>
                        @endif
                        {{-- @if (has_permission('admin.zapier.settings'))
                            <li
                                class="sidebar-second-li {{ $current_route == 'admin.zapier.settings' ? 'active' : '' }}">
                                <a
                                    href="{{ route('admin.zapier.settings') }}">{{ get_phrase('Zapier Settings') }}</a>
                            </li>
                        @endif --}}
                        @if (has_permission('admin.certificate.settings'))
                            <li
                                class="sidebar-second-li {{ $current_route == 'admin.certificate.settings' ? 'active' : '' }}">
                                <a
                                    href="{{ route('admin.certificate.settings') }}">{{ get_phrase('Certificate Settings') }}</a>
                            </li>
                        @endif
                        @if (has_permission('admin.player.settings'))
                            <li
                                class="sidebar-second-li {{ $current_route == 'admin.player.settings' ? 'active' : '' }}">
                                <a
                                    href="{{ route('admin.player.settings') }}">{{ get_phrase('Player Settings') }}</a>
                            </li>
                        @endif
                        @if (has_permission('admin.open.ai.settings'))
                            <li
                                class="sidebar-second-li {{ $current_route == 'admin.open.ai.settings' ? 'active' : '' }}">
                                <a
                                    href="{{ route('admin.open.ai.settings') }}">{{ get_phrase('Open AI Settings') }}</a>
                            </li>
                        @endif
                        @if (has_permission('admin.pages'))
                            <li class="sidebar-second-li {{ $current_route == 'admin.pages' ? 'active' : '' }}"><a
                                    href="{{ route('admin.pages') }}">{{ get_phrase('Home Page Builder') }}</a>
                            </li>
                        @endif
                        @if (has_permission('admin.seo.settings'))
                            <li
                                class="sidebar-second-li {{ $current_route == 'admin.seo.settings' ? 'active' : '' }}">
                                <a href="{{ route('admin.seo.settings') }}">{{ get_phrase('SEO Settings') }}</a>
                            </li>
                        @endif
                        @if (has_permission('admin.about'))
                            <li class="sidebar-second-li {{ $current_route == 'admin.about' ? 'active' : '' }}"><a
                                    href="{{ route('admin.about') }}">{{ get_phrase('About') }}</a></li>
                        @endif
                    </ul>
                </li>

                @if (has_permission('admin.manage.profile'))
                    <li class="sidebar-first-li {{ $current_route == 'admin.manage.profile' ? 'active' : '' }}">
                        <a href="{{ route('admin.manage.profile') }}">
                            <span class="icon fi-rr-circle-user"></span>
                            <div class="text">
                                <span>{{ get_phrase('Manage Profile') }}</span>
                            </div>
                        </a>
                    </li>
                @endif
            </ul>
        </nav>
    @endif
</div>

<script>
    "use strict";
    document.addEventListener("DOMContentLoaded", function() {
        // Restore scroll position if it exists in localStorage
        const scrollPos = localStorage.getItem('navScrollPos');
        const sidebarNavArea = document.querySelector('.sidebar-nav-area');
        if (scrollPos) {
            sidebarNavArea.scrollTop = scrollPos;
        }

        // Ensure the active element is visible
        const activeElement = document.querySelector('.sidebar-nav-area .active');
        if (activeElement) {
            const activeElementTop = activeElement.getBoundingClientRect().top;
            const navAreaTop = sidebarNavArea.getBoundingClientRect().top;
            const navAreaBottom = navAreaTop + sidebarNavArea.clientHeight;

            if (activeElementTop < navAreaTop || activeElementTop > navAreaBottom) {
                sidebarNavArea.scrollTop = activeElement.offsetTop - sidebarNavArea.offsetTop;
            }
        }

        // Save scroll position before page unload
        window.addEventListener('beforeunload', function() {
            localStorage.setItem('navScrollPos', sidebarNavArea.scrollTop);
        });
    });
</script>
