@extends('layouts.superadmin')

@push('title', get_phrase('Payment'))

@push('meta')
@endpush

@push('css')
@endpush

@section('content')
<div class="ol-card radius-8px">
    <div class="ol-card-body my-3 py-12px px-20px">
        <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
            <h4 class="title fs-16px">
                <i class="fi-rr-settings-sliders me-2"></i>
                {{ get_phrase('All Payment') }} <span class="text-muted">({{ $payments->count() }})</span>
            </h4>
        </div>
    </div>
</div>
<div class="ol-card radius-8px">
    <div class="ol-card-body my-3 py-12px px-20px">
        <div class="container">
            <h4 class="title fs-16px">                
                {{ get_phrase('Payment  Chart') }} 
            </h4>
            <canvas id="paymentHistoryChart" height="80"></canvas>
        </div>
    </div>
</div>


<div class="row">
    <div class="col-12">
        <div class="ol-card">
            <div class="ol-card-body p-3">
                <div class="row print-d-none mb-3 mt-3 row-gap-3">
                    <div class="col-md-6 pt-2 pt-md-0  d-flex align-items-center gap-3">
                        <div class="custom-dropdown">
                            <button class="dropdown-header btn ol-btn-light">
                                {{ get_phrase('Export') }}
                                <i class="fi-rr-file-export ms-2"></i>
                            </button>
                            <ul class="dropdown-list">
                                <li>
                                    <a class="dropdown-item" href="#" onclick="downloadPDF('.print-table', 'package-list')"><i class="fi-rr-file-pdf"></i> {{ get_phrase('PDF') }}</a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="#" onclick="window.print();"><i class="fi-rr-print"></i> {{ get_phrase('Print') }}</a>
                                </li>
                            </ul>
                        </div>
                        <div class="custom-dropdown dropdown-filter @if (!isset($_GET) || (isset($_GET) && count($_GET) == 0))  @endif">
                                <button class="dropdown-header btn ol-btn-light">
                                    <i class="fi-rr-filter me-2"></i>
                                    {{ get_phrase('Filter') }}

                                    @if (isset($_GET) && count($_GET))
                                        <span class="text-12px">
                                            ({{ count($_GET) }})
                                        </span>
                                    @endif
                                </button>
                                <ul class="dropdown-list w-250px">
                                    <li>
                                        <form id="filter-dropdown" action="{{ route('superadmin.payment_history.index') }}" method="get">
                                            <div class="filter-option d-flex flex-column gap-3">
                                                <div>
                                                    <label for="eDataList" class="form-label ol-form-label">{{ get_phrase('Status') }}</label>
                                                    <select class="form-control ol-form-control ol-select2" data-toggle="select2" name="status" data-placeholder="Type to search...">
                                                        <option value="all">{{ get_phrase('All') }}</option>
                                                        <option value="active" @if (isset($_GET['status']) && $_GET['status'] == 'active') selected @endif>{{ get_phrase('Active') }}</option>
                                                        <option value="expired" @if (isset($_GET['status']) && $_GET['status'] == 'expired') selected @endif>{{ get_phrase('Expired') }}</option>
                                                        <option value="canceled" @if (isset($_GET['status']) && $_GET['status'] == 'canceled') selected @endif>{{ get_phrase('Canceled') }}</option>
                                                    </select>
                                                </div>
                                                <div>
                                                    <label for="eDataList" class="form-label ol-form-label">{{ get_phrase('Package Name') }}</label>
                                                    <select class="form-control ol-form-control ol-select2" data-toggle="select2" name="package_id" data-placeholder="Type to search...">
                                                        <option value="all">{{ get_phrase('All') }}</option>
                                                        @foreach ($packages as $package)
                                                            <option value="{{ $package->id }}" 
                                                                @if (isset($_GET['package_id']) && $_GET['package_id'] == $package->id) selected @endif>
                                                                {{ $package->title }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div>
                                                    <label class="form-label ol-form-label">{{ get_phrase('Purchase Date Range') }}</label>
                                                    <input type="text" name="purchase_date_range" class="form-control ol-form-control"
                                                        value="{{ request('purchase_date_range') }}" placeholder="Select date range">
                                                </div>

                                                <div>
                                                    <label class="form-label ol-form-label">{{ get_phrase('Expire Date Range') }}</label>
                                                    <input type="text" name="expire_date_range" class="form-control ol-form-control"
                                                        value="{{ request('expire_date_range') }}" placeholder="Select date range">
                                                </div>


                                            </div>
                                            <div class="filter-button d-flex justify-content-end align-items-center mt-3">
                                                <button type="submit" class="ol-btn-primary">{{ get_phrase('Apply') }}</button>
                                            </div>
                                        </form>
                                    </li>
                                </ul>
                        </div>
                    </div>
                    

                    <div class="col-md-6 mt-3 mt-md-0">
                        <form action="{{ route('superadmin.payment_history.index') }}" method="get" class="d-flex gap-3 justify-content-end">
                            <div class="search-input flex-grow-1">
                                <input type="text" name="search" value="{{ request('search') }}" placeholder="{{ get_phrase('Search') }}" class="ol-form-control form-control" />

                            </div>
                            <button type="submit" class="btn ol-btn-primary" id="submit-button">{{ get_phrase('Search') }}</button>
                        </form>
                    </div>
                </div>
                <!-- Table -->
                @if (count($payments) > 0)
                    <div class="admin-tInfo-pagi d-flex justify-content-between justify-content-center align-items-center flex-wrap gr-15">
                        <p class="admin-tInfo">
                            {{ get_phrase('Showing') . ' ' . count($payments) . ' ' . get_phrase('of') . ' ' . $payments->total() . ' ' . get_phrase('data') }}
                        </p>
                    </div>
                    <div class="table-responsive course_list" id="course_list">
                        <table class="table eTable eTable-2 print-table">
                            <thead>
                                <tr>
                                    <th scope="col">#</th>
                                    <th  scope="col">{{ get_phrase('Company Name') }}</th>
                                    <th  scope="col">{{ get_phrase('Company URL') }}</th>
                                    <th  scope="col">{{ get_phrase('Payment Type') }}</th>
                                    <th  scope="col">{{ get_phrase('Status') }}</th>
                                    <th  scope="col">{{ get_phrase('Package Name') }}</th>
                                    <th  scope="col">{{ get_phrase('Amount') }}</th>
                                    <th  scope="col">{{ get_phrase('Date Added') }}</th>
                                    <th  scope="col">{{ get_phrase('Expire Date') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($payments as $key => $payment)
                                    <tr>
                                        <th scope="row">
                                            <p class="row-number">{{ ++$key }}</p>
                                        </th>

                                        <td>
                                            <div class="dAdmin_profile d-flex align-items-center min-w-200px">
                                                <div class="dAdmin_profile_name">
                                                    <h4 class="title fs-14px">{{ ucfirst($payment->company->name) }}</h4>
                                                </div>
                                            </div>
                                        </td>

                                        <td>
                                            <div class="dAdmin_profile d-flex align-items-center min-w-200px">
                                                <div class="dAdmin_profile_name">
                                                    <h4 class="title fs-14px">{{ $payment->company->company_url }}</h4>
                                                </div>
                                            </div>
                                        </td>

                                        <td>
                                            <div class="dAdmin_info_name min-w-150px">
                                                <p>
                                                    {{ ucfirst($payment->payment_type) }}
                                                </p>
                                            </div>
                                        </td>

                                        <td>
                                            <div class="dAdmin_info_name min-w-150px">
                                                {{ ucfirst($payment->company->status) }}
                                            </div>
                                        </td>
                                        <td>
                                            <div class="dAdmin_info_name min-w-150px">
                                                {{ $payment->package->title }}
                                            </div>
                                        </td>
                                        <td>
                                            <div class="dAdmin_info_name min-w-150px">
                                                {{ currency($payment->amount, 2) }}
                                            </div>
                                        </td>
                                        <td>
                                            <div class="dAdmin_info_name min-w-150px">
                                                {{ \Carbon\Carbon::parse($payment->date_added)->format('d M Y') }}
                                            </div>
                                        </td>
                                        <td>
                                            <div class="dAdmin_info_name min-w-150px">
                                              {{ \Carbon\Carbon::parse($payment->company->expire_date)->format('d M Y') }}
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    @include('superadmin.no_data')
                @endif
                <!-- Data info and Pagination -->
                @if (count($payments) > 0)
                    <div class="admin-tInfo-pagi d-flex justify-content-between justify-content-center align-items-center flex-wrap gr-15">
                        <p class="admin-tInfo">
                            {{ get_phrase('Showing') . ' ' . count($payments) . ' ' . get_phrase('of') . ' ' . $payments->total() . ' ' . get_phrase('data') }}
                        </p>
                        {{ $payments->links() }}
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>



<script>
    $(function() {
    // Purchase Date Range
    $('input[name="purchase_date_range"]').daterangepicker({
        autoUpdateInput: false,
        locale: {
            cancelLabel: 'Clear'
        }
    });

    $('input[name="purchase_date_range"]').on('apply.daterangepicker', function(ev, picker) {
        $(this).val(picker.startDate.format('YYYY-MM-DD') + ' to ' + picker.endDate.format('YYYY-MM-DD'));
    });

    $('input[name="purchase_date_range"]').on('cancel.daterangepicker', function(ev, picker) {
        $(this).val('');
    });

    // Expire Date Range
    $('input[name="expire_date_range"]').daterangepicker({
        autoUpdateInput: false,
        locale: {
            cancelLabel: 'Clear'
        }
    });

    $('input[name="expire_date_range"]').on('apply.daterangepicker', function(ev, picker) {
        $(this).val(picker.startDate.format('YYYY-MM-DD') + ' to ' + picker.endDate.format('YYYY-MM-DD'));
    });

    $('input[name="expire_date_range"]').on('cancel.daterangepicker', function(ev, picker) {
        $(this).val('');
    });
});
</script>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    const ctx = document.getElementById('paymentHistoryChart').getContext('2d');
    const paymentHistoryChart = new Chart(ctx, {
        type: 'line', // bar / line / pie যেকোনো দিতে পারো
        data: {
            labels: @json($labels), // তারিখ
            datasets: [{
                label: 'Total Payment Amount',
                data: @json($data), // amount sum
                borderColor: 'rgba(75, 192, 192, 1)',
                backgroundColor: 'rgba(75, 192, 192, 0.2)',
                borderWidth: 2,
                fill: true,
                tension: 0.4 // curve effect
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: { display: true },
                tooltip: { enabled: true }
            },
            scales: {
                x: { title: { display: true, text: 'Date' } },
                y: { title: { display: true, text: 'Amount' }, beginAtZero: true }
            }
        }
    });
</script>
@endsection

