<?php $current_route = Route::currentRouteName(); ?>

<div class="sidebar-logo-area">
    <a href="#" class="sidebar-logos">
        <img class="sidebar-logo-lg" height="50px" src="<?php echo e(get_image(get_frontend_settings('dark_logo'))); ?>"
            alt="">
        <img class="sidebar-logo-sm" height="40px" src="<?php echo e(get_image(get_frontend_settings('favicon'))); ?>" alt="">
    </a>
    <button class="sidebar-cross menu-toggler d-block d-lg-none">
        <span class="fi-rr-cross"></span>
    </button>
</div>
<h3 class="sidebar-title fs-12px px-30px pb-20px text-uppercase mt-4"><?php echo e(get_phrase('Main Menu')); ?></h3>
<div class="sidebar-nav-area">
    <nav class="sidebar-nav">
        <ul class="px-14px pb-24px">

                <li class="sidebar-first-li <?php echo e($current_route == 'superadmin.dashboard' ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('superadmin.dashboard')); ?>">
                        <span class="icon fi-rr-house-blank"></span>
                        <div class="text">
                            <span><?php echo e(get_phrase('Dashboard')); ?></span>
                        </div>
                    </a>
                </li>

                <li class="sidebar-first-li <?php echo e($current_route == 'superadmin.client.index' ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('superadmin.client.index')); ?>">
                        <span class="icon fi-rr-users"></span>
                        <div class="text">
                            <span><?php echo e(get_phrase('Users')); ?></span>
                        </div>
                    </a>
                </li>

                <li class="sidebar-first-li <?php echo e($current_route == 'superadmin.package.index' ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('superadmin.package.index')); ?>">
                        <span class="icon fi-rr-chart-tree-map"></span>
                        <div class="text">
                            <span><?php echo e(get_phrase('Package')); ?></span>
                        </div>
                    </a>
                </li>

                <li class="sidebar-first-li <?php echo e($current_route == 'superadmin.payment_history.index' ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('superadmin.payment_history.index')); ?>">
                        <span class="icon fi-rr-comment-dollar"></span>
                        <div class="text">
                            <span><?php echo e(get_phrase('Payment History')); ?></span>
                        </div>
                    </a>
                </li>

        </ul>
    </nav>



    <?php if(has_permission('admin.system.settings') ||
            has_permission('admin.website.settings') ||
            has_permission('admin.payment.settings') ||
            has_permission('admin.manage.language') ||
            has_permission('admin.notification.settings') ||
            // has_permission('admin.zapier.settings') ||
            has_permission('admin.amazom_s3.settings') ||
            has_permission('admin.live.class.settings') ||
            has_permission('admin.certificate.settings') ||
            has_permission('admin.player.settings') ||
            has_permission('admin.open.ai.settings') ||
            has_permission('admin.pages') ||
            has_permission('admin.seo.settings') ||
            has_permission('admin.about')): ?>
        <nav class="sidebar-nav">
            <h3 class="sidebar-title fs-12px px-30px text-uppercase pb-3"><?php echo e(get_phrase('Settings')); ?></h3>
            <ul class="px-14px pb-24px mb-5 pb-5">
                <li
                    class="sidebar-first-li first-li-have-sub <?php echo e($current_route == 'admin.system.settings' || $current_route == 'admin.website.settings' || $current_route == 'admin.language.phrase.edit' || $current_route == 'admin.payment.settings' || $current_route == 'admin.manage.language' || $current_route == 'admin.notification.settings' || $current_route == 'admin.amazom_s3.settings' || $current_route == 'admin.live.class.settings' || $current_route == 'admin.live.class.settings' || $current_route == 'admin.certificate.settings' || $current_route == 'admin.player.settings' || $current_route == 'admin.open.ai.settings' || $current_route == 'admin.pages' || $current_route == 'admin.seo.settings' || $current_route == 'admin.about' ? 'active' : ''); ?>">
                    <a href="javascript:void(0);">
                        <span class="icon fi fi-rr-settings"></span>
                        <div class="text">
                            <span><?php echo e(get_phrase('System Settings')); ?></span>
                        </div>
                    </a>
                    <ul class="first-sub-menu">
                        <li class="first-sub-menu-title fs-14px mb-18px"><?php echo e(get_phrase('System Settings')); ?></li>
                        <?php if(has_permission('admin.system.settings')): ?>
                            <li
                                class="sidebar-second-li <?php echo e($current_route == 'admin.system.settings' ? 'active' : ''); ?>">
                                <a
                                    href="<?php echo e(route('admin.system.settings')); ?>"><?php echo e(get_phrase('System Settings')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(has_permission('admin.website.settings')): ?>
                            <li
                                class="sidebar-second-li <?php echo e($current_route == 'admin.website.settings' ? 'active' : ''); ?>">
                                <a
                                    href="<?php echo e(route('admin.website.settings')); ?>"><?php echo e(get_phrase('Website Settings')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(has_permission('admin.payment.settings')): ?>
                            <li
                                class="sidebar-second-li <?php echo e($current_route == 'admin.payment.settings' ? 'active' : ''); ?>">
                                <a
                                    href="<?php echo e(route('admin.payment.settings')); ?>"><?php echo e(get_phrase('Payment Settings')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(has_permission('admin.manage.language')): ?>
                            <li
                                class="sidebar-second-li <?php echo e($current_route == 'admin.manage.language' || $current_route == 'admin.language.phrase.edit' ? 'active' : ''); ?>">
                                <a
                                    href="<?php echo e(route('admin.manage.language')); ?>"><?php echo e(get_phrase('Manage Language')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(has_permission('admin.live.class.settings')): ?>
                            <li
                                class="sidebar-second-li <?php echo e($current_route == 'admin.live.class.settings' ? 'active' : ''); ?>">
                                <a
                                    href="<?php echo e(route('admin.live.class.settings')); ?>"><?php echo e(get_phrase('Live Class Settings')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(has_permission('admin.notification.settings')): ?>
                            <li
                                class="sidebar-second-li <?php echo e($current_route == 'admin.notification.settings' ? 'active' : ''); ?>">
                                <a
                                    href="<?php echo e(route('admin.notification.settings')); ?>"><?php echo e(get_phrase('SMTP Settings')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(has_permission('admin.amazom_s3.settings')): ?>
                            <li
                                class="sidebar-second-li <?php echo e($current_route == 'admin.amazom_s3.settings' ? 'active' : ''); ?>">
                                <a
                                    href="<?php echo e(route('admin.amazom_s3.settings')); ?>"><?php echo e(get_phrase('Amazon s3 settings ')); ?></a>
                            </li>
                        <?php endif; ?>
                        
                        <?php if(has_permission('admin.certificate.settings')): ?>
                            <li
                                class="sidebar-second-li <?php echo e($current_route == 'admin.certificate.settings' ? 'active' : ''); ?>">
                                <a
                                    href="<?php echo e(route('admin.certificate.settings')); ?>"><?php echo e(get_phrase('Certificate Settings')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(has_permission('admin.player.settings')): ?>
                            <li
                                class="sidebar-second-li <?php echo e($current_route == 'admin.player.settings' ? 'active' : ''); ?>">
                                <a
                                    href="<?php echo e(route('admin.player.settings')); ?>"><?php echo e(get_phrase('Player Settings')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(has_permission('admin.open.ai.settings')): ?>
                            <li
                                class="sidebar-second-li <?php echo e($current_route == 'admin.open.ai.settings' ? 'active' : ''); ?>">
                                <a
                                    href="<?php echo e(route('admin.open.ai.settings')); ?>"><?php echo e(get_phrase('Open AI Settings')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(has_permission('admin.pages')): ?>
                            <li class="sidebar-second-li <?php echo e($current_route == 'admin.pages' ? 'active' : ''); ?>"><a
                                    href="<?php echo e(route('admin.pages')); ?>"><?php echo e(get_phrase('Home Page Builder')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(has_permission('admin.seo.settings')): ?>
                            <li
                                class="sidebar-second-li <?php echo e($current_route == 'admin.seo.settings' ? 'active' : ''); ?>">
                                <a href="<?php echo e(route('admin.seo.settings')); ?>"><?php echo e(get_phrase('SEO Settings')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(has_permission('admin.about')): ?>
                            <li class="sidebar-second-li <?php echo e($current_route == 'admin.about' ? 'active' : ''); ?>"><a
                                    href="<?php echo e(route('admin.about')); ?>"><?php echo e(get_phrase('About')); ?></a></li>
                        <?php endif; ?>
                    </ul>
                </li>

                <?php if(has_permission('admin.manage.profile')): ?>
                    <li class="sidebar-first-li <?php echo e($current_route == 'admin.manage.profile' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.manage.profile')); ?>">
                            <span class="icon fi-rr-circle-user"></span>
                            <div class="text">
                                <span><?php echo e(get_phrase('Manage Profile')); ?></span>
                            </div>
                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </nav>
    <?php endif; ?>
</div>

<script>
    "use strict";
    document.addEventListener("DOMContentLoaded", function() {
        // Restore scroll position if it exists in localStorage
        const scrollPos = localStorage.getItem('navScrollPos');
        const sidebarNavArea = document.querySelector('.sidebar-nav-area');
        if (scrollPos) {
            sidebarNavArea.scrollTop = scrollPos;
        }

        // Ensure the active element is visible
        const activeElement = document.querySelector('.sidebar-nav-area .active');
        if (activeElement) {
            const activeElementTop = activeElement.getBoundingClientRect().top;
            const navAreaTop = sidebarNavArea.getBoundingClientRect().top;
            const navAreaBottom = navAreaTop + sidebarNavArea.clientHeight;

            if (activeElementTop < navAreaTop || activeElementTop > navAreaBottom) {
                sidebarNavArea.scrollTop = activeElement.offsetTop - sidebarNavArea.offsetTop;
            }
        }

        // Save scroll position before page unload
        window.addEventListener('beforeunload', function() {
            localStorage.setItem('navScrollPos', sidebarNavArea.scrollTop);
        });
    });
</script>
<?php /**PATH C:\MAMP\htdocs\academy_lms_sass\academy\resources\views/superadmin/navigation.blade.php ENDPATH**/ ?>