
<?php $__env->startPush('title', get_phrase('Dashboard')); ?>
<?php $__env->startPush('meta'); ?><?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>

<style>
    .btn-gradient {
        background: linear-gradient(135deg, #4f46e5, #9333ea);
        color: #fff;
        border: none;
        transition: all 0.3s ease;
        font-size: 14px;
    }
    .btn-gradient:hover {
        opacity: 0.95;
        transform: translateY(-2px);
        box-shadow: 0 8px 20px rgba(0,0,0,0.2);
        color: #fff;
    }
</style>
<div class="ol-card radius-8px">
    <div class="ol-card-body my-3 py-12px px-20px">
        <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
            <h4 class="title fs-16px">
                <i class="fi-rr-settings-sliders me-2"></i>
                <?php echo e(get_phrase('Purchase Package')); ?>

            </h4>
        </div>
    </div>
</div>
<div class="row justify-content-center">
    <div class="col-lg-10">
        <div class="ol-card border-0 shadow-lg rounded-4 overflow-hidden mb-5">
            <div class="row g-0">
                
                <!-- Left Side: Package Details -->
                <div class="col-lg-6 bg-light p-5 d-flex flex-column justify-content-center">
                    <h4 class="fw-bold mb-3 text-primary"><?php echo e($package->title); ?></h4>
                    <p class="text-muted mb-4"><?php echo e($package->description); ?></p>

                    <h3 class="fw-bold text-dark mb-4">
                        <?php echo e(currency($package->price, 2)); ?>

                        <small class="fs-6 text-muted">/ <?php echo e(ucfirst($package->interval)); ?></small>
                    </h3>

                    <?php if(!empty($package->features)): ?>
                        <ul class="list-unstyled">
                            <?php $__currentLoopData = json_decode($package->features, true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="mb-3 d-flex align-items-center">
                                    <i style="font-size: 12px;" class="fas fa-check-circle text-success me-2"></i>
                                    <span><?php echo e($feature); ?></span>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    <?php endif; ?>
                </div>

                <!-- Right Side: Purchase Form -->
                <div class="col-lg-6 p-5 bg-white d-flex flex-column justify-content-center">
                    <h4 class="fw-bold mb-4"><?php echo e(get_phrase('Complete Your Purchase')); ?></h4>

                    <form action="<?php echo e(route('client.package.payout', $package->id)); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <!-- Domain URL Input -->
                        <div class="mb-4 position-relative">
                            <label for="name" class="form-label fw-semibold">
                                <?php echo e(get_phrase('Company name')); ?>

                            </label>
                            <input type="text" name="company_name" id="company_name" 
                                class="form-control p-3 rounded-3 border border-2"
                                placeholder="Company Name" autocomplete="off" required>
                            
                            <!-- Loader / Status Icon -->
                            <span id="name-status-icon" 
                                class="position-absolute" 
                                style="top: 58px; right: 15px;"></span>

                            <!-- Dynamic feedback text -->
                            <small id="name-feedback" class="d-block mt-2"></small>

                            <!-- Hidden input to store generated URL -->
                            <input type="hidden" name="company_url" id="company_url">
                        </div>

                        <!-- Submit Button -->
                        <button type="submit" 
                                class="btn btn-gradient w-100 rounded-pill py-3 fw-semibold shadow-sm fs-5">
                            <?php echo e(get_phrase('Purchase Now')); ?>

                        </button>
                    </form>
                </div>

            </div>
        </div>
    </div>
</div>

<script>
"use strict";

$(document).ready(function(){
    let timer;
    const input = $('#company_name');
    const icon = $('#name-status-icon');
    const feedback = $('#name-feedback');

    input.on('keyup', function(){
        clearTimeout(timer);
        icon.html('<div class="spinner-border spinner-border-sm text-secondary"></div>');
        feedback.text('');

        timer = setTimeout(() => {
            const name = input.val().trim();
            if(name.length === 0){
                icon.html('');
                feedback.text('');
                return;
            }

            $.ajax({
                url: "<?php echo e(route('client.check.company.name')); ?>",
                type: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    name: name
                },
                success: function(response){
                    if(response.status === 'taken'){
                        icon.html('<i class="fas fa-times-circle text-danger fs-5"></i>');
                        input.removeClass('border-success').addClass('border-danger');
                        feedback.removeClass('text-success').addClass('text-danger')
                            .text(response.message);
                            $('#company_url').val('');
                    } else {
                        icon.html('<i class="fas fa-check-circle text-success fs-5"></i>');
                        input.removeClass('border-danger').addClass('border-success');
                        feedback.removeClass('text-danger').addClass('text-success')
                            .text("Available! Your URL will be: " + response.url);
                            $('#company_url').val(response.url); // set url here
                    }

                },
                error: function(){
                    icon.html('<i class="bi bi-x-circle-fill text-danger fs-5"></i>');
                    feedback.removeClass('text-success').addClass('text-danger')
                        .text('Error checking name.');
                }
            });

        }, 500); // debounce for smooth typing
    });
});
</script>



<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.client', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\MAMP\htdocs\academy_lms_sass\academy\resources\views/client/package/purchase.blade.php ENDPATH**/ ?>